
#ifdef TEXTURE
varying vec2 f_texcoord;
uniform sampler2D texture;
#else
uniform vec3 color;
#endif

#ifdef HIGHLIGHT
uniform vec4 highlight;
varying float f_highlight_factor;
#endif

#ifdef ALPHA
uniform float alpha;
#endif


void main(void)
{
#ifdef TEXTURE
	vec4 colorResult = texture2D(texture, f_texcoord);
#else
	vec4 colorResult = vec4(color, 1.0);
#endif

#ifdef HIGHLIGHT
	colorResult = mix(colorResult, vec4(highlight.xyz, colorResult.a), highlight.w*f_highlight_factor);
#endif

#ifdef ALPHA
	colorResult.w *= alpha;
#endif

#ifdef ALPHA_TEST
	const float alphaTestRef = 0.1;
	if(colorResult.w < alphaTestRef)
	{
		colorResult.w = 0.0;
		discard;
	}
#endif

	gl_FragColor = colorResult;
}
